<?php

namespace App\Http\Controllers;

use App\Models\Attendance;
use App\Http\Requests\StoreAttendanceRequest;
use App\Http\Requests\UpdateAttendanceRequest;
use App\Models\ClassRoom;
use App\Models\Lesson;
use App\Models\StudentSubscribe;
use App\Models\User;
use Illuminate\Http\Request;

class AttendanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($classRoomId, $lessonId)
    {
        $classRoom = ClassRoom::find($classRoomId);
        $lesson = Lesson::find($lessonId);
        $subscribeIds = StudentSubscribe::with('student')->where('room_id', $classRoomId)->get()->map(function ($item) {
            return $item->id;
        });
        $attendances = Attendance::with('subscribe')->where('lesson_id', $lessonId)->whereIn('subscribe_id', $subscribeIds)->get();
        return view('attendances.list')->with([
            'classRoom' => $classRoom,
            'lesson' => $lesson,
            'attendances' => $attendances,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($classRoomId, $lessonId)
    {

        $classRoom = ClassRoom::find($classRoomId);
        $lesson = Lesson::find($lessonId);
        $subscribes = StudentSubscribe::with('student')->where('room_id', $classRoomId)->get();
        return view('attendances.modals.create')->with([
            'classRoom' => $classRoom,
            'lesson' => $lesson,
            'students' => $subscribes,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreAttendanceRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreAttendanceRequest $request)
    {
        // try {
        // return $request;
        $subscribers = StudentSubscribe::with('student')->where('room_id', $request->classRoomId)->get()->map(function ($item)
        {
            return $item->id;
        });

        foreach ($subscribers as $subscribe) {
            $newAttendance = Attendance::where('subscribe_id', $subscribe)->where('lesson_id', $request->lessonId)->first();
            if (!isset($newAttendance))
                $newAttendance = new Attendance();
            $newAttendance->subscribe_id = $subscribe;
            $newAttendance->lesson_id = $request->lessonId;
            $newAttendance->save();
        }
        if($request->subscribes){

        foreach ($request->subscribes as $subscribe) {
            $newAttendance = Attendance::where('subscribe_id', $subscribe)->where('lesson_id', $request->lessonId)->first();
            if (!isset($newAttendance))
                $newAttendance = new Attendance();
            $newAttendance->subscribe_id = $subscribe;
            $newAttendance->lesson_id = $request->lessonId;
            $newAttendance->is_present = 1;
            $newAttendance->save();
        }
        }
        return redirect()->route('lesson_attendances_list', $request->classRoomId)->with(['success' => 'تم تحضير المتدربين بنجاح']);
        // } catch (\Throwable $th) {
        //     return back()->with(['error' => 'لم يتم تحضير المتدربين  ']);
        // }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Attendance  $attendance
     * @return \Illuminate\Http\Response
     */
    public function show(Attendance $attendance)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Attendance  $attendance
     * @return \Illuminate\Http\Response
     */
    public function edit(Attendance $attendance)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateAttendanceRequest  $request
     * @param  \App\Models\Attendance  $attendance
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateAttendanceRequest $request, Attendance $attendance)
    {
        //
    }

    /**
     * active and not active course
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function toggle(Request $request)
    {
        try {
            $attendance = Attendance::find($request->id);
            $attendance->is_present *= -1;
            $attendance->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }
}
